/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

#include <vnccommon/EventHandle.h>

using namespace vnccommon;

DirectedEventHandle::DirectedEventHandle(
        const EventHandle handle,
        const bool listenForReadReady,
        const bool listenForWriteReady)

    :   mHandle(handle),
        mListenForReadReady(listenForReadReady),
        mListenForWriteReady(listenForWriteReady)
{
}

EventHandle DirectedEventHandle::getHandle() const
{
    return mHandle;
}

bool DirectedEventHandle::getListenForReadReady() const
{
    return mListenForReadReady;
}

bool DirectedEventHandle::getListenForWriteReady() const
{
    return mListenForWriteReady;
}

bool DirectedEventHandle::operator==(const DirectedEventHandle& o) const
{
    return mHandle == o.mHandle
            && mListenForReadReady == o.mListenForReadReady
            && mListenForWriteReady == o.mListenForWriteReady;
}

